VERSION 5.00
Begin VB.Form Form1 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   1  'Fest Einfach
   Caption         =   "DCF Kalender"
   ClientHeight    =   11025
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   12735
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   735
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   849
   StartUpPosition =   2  'Bildschirmmitte
   Begin VB.VScrollBar ScrollBar 
      Height          =   9600
      LargeChange     =   100
      Left            =   12420
      Max             =   12050
      Min             =   72
      SmallChange     =   10
      TabIndex        =   4
      Top             =   1080
      Value           =   72
      Width           =   315
   End
   Begin VB.PictureBox Picture3 
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   0  'Kein
      Height          =   615
      Left            =   0
      ScaleHeight     =   615
      ScaleWidth      =   12750
      TabIndex        =   5
      Top             =   10680
      Width           =   12750
   End
   Begin VB.PictureBox Picture2 
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   0  'Kein
      Height          =   1095
      Left            =   0
      ScaleHeight     =   1095
      ScaleWidth      =   12750
      TabIndex        =   3
      Top             =   0
      Width           =   12750
      Begin VB.CommandButton cmd_Open 
         Caption         =   "Bilder laden aus:"
         Height          =   375
         Left            =   120
         TabIndex        =   10
         Top             =   120
         Width           =   2775
      End
      Begin VB.ComboBox Combo2 
         Height          =   315
         Left            =   3000
         Style           =   2  'Dropdown-Liste
         TabIndex        =   9
         Top             =   600
         Width           =   2775
      End
      Begin VB.ComboBox Combo1 
         Height          =   315
         Left            =   120
         Style           =   2  'Dropdown-Liste
         TabIndex        =   8
         Top             =   600
         Width           =   2775
      End
      Begin VB.CommandButton cmd_Write 
         Caption         =   "Bilder schreiben auf:"
         Height          =   375
         Left            =   3000
         TabIndex        =   6
         Top             =   120
         Width           =   2775
      End
      Begin VB.Label lbl_Info 
         BackStyle       =   0  'Transparent
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   12
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   735
         Left            =   6000
         TabIndex        =   7
         Top             =   120
         Width           =   6615
      End
   End
   Begin VB.PictureBox Pic_Back 
      Appearance      =   0  '2D
      BackColor       =   &H00808080&
      BorderStyle     =   0  'Kein
      ForeColor       =   &H80000008&
      Height          =   1.92240e5
      Left            =   0
      ScaleHeight     =   13016
      ScaleMode       =   0  'Benutzerdefiniert
      ScaleWidth      =   828
      TabIndex        =   0
      Top             =   1080
      Width           =   12420
      Begin VB.PictureBox Bild 
         Appearance      =   0  '2D
         AutoRedraw      =   -1  'True
         BackColor       =   &H80000005&
         BorderStyle     =   0  'Kein
         ForeColor       =   &H80000008&
         Height          =   2640
         Index           =   0
         Left            =   120
         ScaleHeight     =   176
         ScaleMode       =   3  'Pixel
         ScaleWidth      =   132
         TabIndex        =   1
         Top             =   120
         Visible         =   0   'False
         Width           =   1980
      End
      Begin VB.Label lbl_Txt 
         Alignment       =   2  'Zentriert
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Index           =   0
         Left            =   120
         TabIndex        =   2
         Top             =   2760
         Visible         =   0   'False
         Width           =   1980
      End
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' Datenspeicher fr ein Bild zur MMC Karte
Dim AusgabeFeld(51199) As Byte

Private Declare Function CreateFile Lib "kernel32.dll" Alias "CreateFileA" ( _
  ByVal lpFileName As String, _
  ByVal dwDesiredAccess As Long, _
  ByVal dwShareMode As Long, _
  lpSecurityAttributes As Any, _
  ByVal dwCreationDisposition As Long, _
  ByVal dwFlagsAndAttributes As Long, _
  ByVal hTemplateFile As Long) As Long

' CreateFile dwDesiredAccess Konstanten
Private Const GENERIC_READ = &H80000000 ' Nur Lesen
Private Const GENERIC_WRITE = &H40000000 ' Nur Schreiben
 
' CreateFile dwShareMode Konstanten
Private Const FILE_SHARE_READ = &H1
Private Const FILE_SHARE_WRITE = &H2
 
' CreateFile dwCreationDisposition Konstanten
' ===========================================
' Erstellt eine neue Datei und berschreibt eine bereits vorhandene
Private Const CREATE_ALWAYS = 2
' Erstellt eine neue Datei nur, wenn sie noch nicht existiert
Private Const CREATE_NEW = 1
' ffnet eine bereits vorhande Datei bzw. erstellt diese,
' wenn sie noch nicht existiert
Private Const OPEN_ALWAYS = 4
' ffnet eine bereits vorhandene Datei
Private Const OPEN_EXISTING = 3
' ffnet eine bereits vorhandene Datei und lscht den Inhalt
Private Const TRUNCATE_EXISTING = 5
 
' CreateFile dwFlagsAndAttributes
' ===============================
Private Const FILE_ATTRIBUTE_ARCHIVE = &H20 ' Archiv
Private Const FILE_ATTRIBUTE_HIDDEN = &H2 ' Versteckt
Private Const FILE_ATTRIBUTE_NORMAL = &H80 ' Normal
Private Const FILE_ATTRIBUTE_READONLY = &H1 ' Schreibgeschtzt
Private Const FILE_ATTRIBUTE_SYSTEM = &H4 ' Systemdatei
' Datei wird beim Schlieen gelscht
Private Const FILE_FLAG_DELETE_ON_CLOSE = &H4000000
' Es wird kein Puffer/Cache benutzt
Private Const FILE_FLAG_NO_BUFFERING = &H20000000
' Erlaubt gleichzeitiges Lesen und  Schreiben
' (nicht bei Windows 95, 98, CE)
Private Const FILE_FLAG_OVERLAPPED = &H40000000
' Erlaubt Case-Sensitive Dateinamen
Private Const FILE_FLAG_POSIX_SEMANTICS = &H1000000
' Richtet den Puffer fr einen Random-Access Zugriff aus
Private Const FILE_FLAG_RANDOM_ACCESS = &H10000000
' Richtet den Puffer fr einen sequentuellen Zugriff aus
Private Const FILE_FLAG_SEQUENTIAL_SCAN = &H8000000
' Nutzt keinen Platten-Cache, sondern schreibt direkt in die Datei
Private Const FILE_FLAG_WRITE_THROUGH = &H80000000

Private Declare Function SetFilePointer Lib "kernel32.dll" ( _
  ByVal hFile As Long, _
  ByVal lDistanceToMove As Long, _
  lpDistanceToMoveHigh As Long, _
  ByVal dwMoveMethod As Long) As Long

Private Declare Function WriteFile Lib "kernel32" ( _
  ByVal hFile As Long, _
  lpBuffer As Any, _
  ByVal nNumberOfBytesToWrite As Long, _
  lpNumberOfBytesWritten As Long, _
  lpOverlapped As Long) As Long

Private Declare Function CloseHandle Lib "kernel32.dll" ( _
  ByVal hObject As Long) As Long

Private Declare Function GetDriveType Lib "kernel32.dll" _
  Alias "GetDriveTypeA" ( _
  ByVal nDrive As String) As Long

Private Type Col16Bit
  HighByte As Byte
  LowByte As Byte
End Type

Private Sub Form_Load()
  Dim Spalte As Single
  Dim Zeile As Single
  Dim Counter As Integer
  Dim bTag As Byte
  Dim bMonat As Byte
  Dim sTxt As String
  Dim Pfad1 As String
  Dim Name1 As String
  Dim Dr As String
  Dim DrTp As Long
  Dim TxtTmp As String
    
    
  ' Unterordner aus App.Path in Combo1 darstellen
  Pfad1 = App.Path & "\"
  Name1 = Dir(Pfad1, vbDirectory)
  Do While Name1 <> ""
    If Name1 <> "." And Name1 <> ".." Then
      If (GetAttr(Pfad1 & Name1) And vbDirectory) = vbDirectory Then
        Combo1.AddItem Name1
      End If
    End If
    Name1 = Dir
  Loop
    
  ' Angeschlossene Wechseldatentrger in Combo2 listen
  For Counter = 65 To 90
    Dr = Chr$(Counter)
    Dr = Dr & ":\"
    DrTp = GetDriveType(Dr)
    If DrTp = 2 Then
      Combo2.AddItem Dr
    End If
  Next
       
  ' Ersten Eintrag in Comboboxen markieren
  On Error Resume Next
  Combo1.ListIndex = 0
  Combo2.ListIndex = 0
  On Error GoTo 0
       
  ' Bildboxen erzeugen
  For Zeile = 8 To 12802 Step 200
    For Spalte = 8 To 688 Step 136
      ' Bild erzeugen
      Load Bild((Bild.UBound) + 1)
      Bild(Bild.UBound).Left = Spalte
      Bild(Bild.UBound).Top = Zeile
      Bild(Bild.UBound).Visible = True
      ' Label erzeugen
      Load lbl_Txt((lbl_Txt.UBound) + 1)
      lbl_Txt(lbl_Txt.UBound).Left = Spalte
      lbl_Txt(lbl_Txt.UBound).Top = Zeile + 176
      lbl_Txt(lbl_Txt.UBound).Visible = True
    Next
  Next
  ' Letzten Bilder werden nicht gebraucht... also weg damit
  Unload Bild(384): Unload lbl_Txt(384)
  Unload Bild(383): Unload lbl_Txt(383)
  Unload Bild(382): Unload lbl_Txt(382)
  ' Nun die Datmer in die Textfelder zu jedem Bild schreiben
  Counter = 1
  For bMonat = 1 To 12
    For bTag = 1 To 31
      lbl_Txt(Counter).Caption = Format$(bTag, "00") & "_" & Format$(bMonat, "00") & ".bmp"
      Counter = Counter + 1
    Next
  Next
  ' Letztzen Bilder fr Tag Sync und Default beschriften
  lbl_Txt(373).Caption = "Mo.bmp"
  lbl_Txt(374).Caption = "Di.bmp"
  lbl_Txt(375).Caption = "Mi.bmp"
  lbl_Txt(376).Caption = "Do.bmp"
  lbl_Txt(377).Caption = "Fr.bmp"
  lbl_Txt(378).Caption = "Sa.bmp"
  lbl_Txt(379).Caption = "So.bmp"
  lbl_Txt(380).Caption = "DCF.bmp"
  lbl_Txt(381).Caption = "Default.bmp"
End Sub

Private Sub cmd_Open_Click()
  ' In Combobox1 gewhlten Bilderordner ffnen und Bilder laden und anzeigen
  
  Dim DatName As String
  Dim Counter As Long
  Dim MitDefault As Boolean
    
  ' Raus wenn keine Wahl
  If Combo1.Text = "" Then Exit Sub
  
  Me.MousePointer = vbHourglass
  lbl_Info.Caption = "Lade Bilder"
  DoEvents
  ' Prfen ob Defaultbild vorhanden
  DatName = App.Path & "\" & Combo1.Text & "\Default.bmp"
  If Dir(DatName) <> "" Then MitDefault = True Else MitDefault = False
    
  ' Bilder in Pictureboxen laden
  For Counter = 1 To 381
    DatName = App.Path & "\" & Combo1.Text & "\" & lbl_Txt(Counter).Caption
    If Dir(DatName) <> "" Then
      Bild(Counter).Picture = LoadPicture(DatName)
    Else
      If MitDefault = True Then
        Bild(Counter).Picture = LoadPicture(App.Path & "\" & Combo1.Text & "\Default.bmp")
      Else
        Set Bild(Counter).Picture = Nothing
      End If
    End If
  Next
  Me.MousePointer = vbNormal
  lbl_Info.Caption = "Alle Bilder geladen"
End Sub

Private Sub PicToBytes(picBox As PictureBox)
  ' Sub erwartet als bergabe eine Bildbox (gefllt mit Grafik)
  ' Das Bild wird dann pixelweise gelesen und die 16Bit Farbdaten werden generiert
  ' Die Farbdaten werden dann in der Globalvariable Ausgabefld() gespeichert
  ' Pixel gleich so sortiert wie sie ans S65 Display gesendet werden mssen
  ' Bei Displaygre 132x176 und 16 Bit Farbe werden also 132x176x2 = 46464 Bytes gespeichert
  ' Die restlichen Bytes werden mit Nullen gefllt
  Dim X As Single
  Dim Y As Single
  Dim Counter As Long
  Dim Frb As Col16Bit
  Dim fs, a
  Dim zCount As Long
    
  Counter = 0
  For Y = 0 To 175
    For X = 0 To 131
      ' Farbe Pixel lesen und in 16Bit Format konvertieren
      Frb = RGB888ToRGB565(picBox.Point(X, Y))
      ' High und dann Low Byte in ByteArry speichern
      AusgabeFeld(Counter) = Frb.HighByte: Counter = Counter + 1
      AusgabeFeld(Counter) = Frb.LowByte: Counter = Counter + 1
    Next
  Next
  ' Rest mit Nullen fllen
  For Counter = 46464 To 51199
    AusgabeFeld(Counter) = 0
  Next
End Sub

Private Function RGB888ToRGB565(ByVal Farbe As Long) As Col16Bit
  ' Funktion wandelt einen Long-Farbwert (RGB888) in einen
  ' 16Bit Farbwert RGB565
  ' Rckgabe erfolgt in Low und Highbyte getrennt
  
  Dim sR As String
  Dim sG As String
  Dim sB As String
  Dim sHigh As String
  Dim sLow As String
  Dim btmp As Byte
  Dim Retval As Col16Bit
        
  ' bergebene Farbe in RGB trennen und in 3 String-Bytes wandeln
  btmp = CByte(Farbe \ &H10000 And &HFF&)
  sB = Byte2String(btmp)
  btmp = CByte(Farbe And &HFF&)
  sR = Byte2String(btmp)
  btmp = CByte(Farbe \ &H100& And &HFF&)
  sG = Byte2String(btmp)
    
  ' 3Byte nach RGB565 und in 2Byte konvertieren
  sHigh = Left$(sR, 5) & Left$(sG, 3)
  sLow = Mid$(sG, 4, 3) & Left$(sB, 5)
  
  ' Rckgabe fllen
  Retval.HighByte = String2Byte(sHigh)
  Retval.LowByte = String2Byte(sLow)
  RGB888ToRGB565 = Retval
End Function

Private Function String2Byte(ByVal Wert As String) As Byte
  ' Diese Funktion wandelt einen 8 Zeichen String mit 0en & 1en
  ' in ein Byte. Im String ist das MSB das erste und LSB das letzte Zeichen
  Dim zhler As Integer
  Dim Ausgabe As Byte
 
  For zhler = 0 To 7
    If Mid$(Wert, zhler + 1, 1) = "1" Then
      Ausgabe = Ausgabe + 2 ^ (7 - zhler)
    End If
  Next
  String2Byte = Ausgabe
End Function

Private Function Byte2String(ByVal Wert As Byte) As String
  ' Diese Funktion wandelt ein Byte in einen String um
  ' Im String ist das MSB das erste und das LSB das letzte Zeichen
  Dim zhler As Integer
  Dim Ausgabe As String
 
  For zhler = 7 To 0 Step -1
    If Wert >= 2 ^ zhler Then
      Ausgabe = Ausgabe & "1"
      Wert = Wert - 2 ^ zhler
    Else
      Ausgabe = Ausgabe & "0"
    End If
  Next
  Byte2String = Ausgabe
End Function

Private Sub ScrollBar_Change()
  ' Hintergrundbildbox (auf der die Einzelbilder sind
  ' wird verschoben
  Dim Pos As Single
    
  Pos = ScrollBar.Value
  Pos = -Pos
  Pos = Pos + 148
  Pic_Back.Top = Pos
End Sub

Private Sub ScrollBar_Scroll()
' Hintergrundbildbox (auf der die Einzelbilder sind
  ' wird verschoben
  Dim Pos As Single
    
  Pos = ScrollBar.Value
  Pos = -Pos
  Pos = Pos + 148
  Pic_Back.Top = Pos
End Sub

Private Sub WritePic(ByVal DatentrgerBUCHSTABE As String, ByVal Adresse As Long)
  ' Schreibt auf den bergebenen Datentrger NUR BUCHSTABE
  ' Ab der Adresse "Adresse" 51200 Bytes die in der global Var "Ausgabefeld() stehen
        
  Dim Handle As Long
  Dim nBytesWritten As Long
  Dim Retval As Long
  Dim Counter As Long
    
  Handle = CreateFile("\\.\" & DatentrgerBUCHSTABE & ":", GENERIC_WRITE, 0, ByVal 0&, OPEN_EXISTING, 0, 0)
  If Handle = -1 Then MsgBox "Schreibfehler", vbCritical: Exit Sub
  SetFilePointer Handle, Adresse, ByVal 0&, 0
  Retval = WriteFile(Handle, AusgabeFeld(LBound(AusgabeFeld)), 51200, nBytesWritten, ByVal 0&)
  If Retval = 0 Then MsgBox "Schreibfehler", vbCritical
  CloseHandle Handle
End Sub

Private Sub cmd_Write_Click()
  ' Hier werden ALLE Bilder auf den ausgewhlten Datentrger geschrieben
  Dim LW As String
  Dim Counter As Long
  Dim AdrCnt As Long
    
    
  ' Raus wenn kein Ziellaufwerk gewhlt
  If Combo2.Text = "" Then Exit Sub
      
  LW = Combo2.Text
  LW = Left$(LW, 1)
    
  Me.MousePointer = vbHourglass
  ' Als erstes wird die Kennung "KALENDER" ab der logischen Adresse (hier vom PC aus) 0
  ' gespeichert
  ' Die Kennung ist 8 Bytes lang, dann folgen 51192 0-Bytes
  ' Nimmt also die Gre eines ganzen Bildes ein
  lbl_Info.Caption = "Schreibe Kennung"
  DoEvents
  AusgabeFeld(0) = 75
  AusgabeFeld(1) = 65
  AusgabeFeld(2) = 76
  AusgabeFeld(3) = 69
  AusgabeFeld(4) = 78
  AusgabeFeld(5) = 68
  AusgabeFeld(6) = 69
  AusgabeFeld(7) = 82
  For Counter = 8 To 51199
    AusgabeFeld(Counter) = 0
  Next
  AdrCnt = 0
  WritePic LW, AdrCnt
  ' Alle Bilder durchlaufen und auf der Karte speichern
  For Counter = 1 To 381
    lbl_Info.Caption = "Schreibe Bild " & CStr(Counter) & " von 381"
    DoEvents
    PicToBytes Bild(Counter)
    AdrCnt = 51200 * Counter
    AdrCnt = AdrCnt
    WritePic LW, AdrCnt
    DoEvents
  Next
  Me.MousePointer = vbNormal
  lbl_Info.Caption = "Schreiben abgeschlossen"
End Sub
